// Version/Precision tags are added programmatically on shader load

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;

uniform mat4  mProj;
uniform mat4  mView;
uniform vec3  uLightPos;
uniform vec3  uEyePosition;
uniform mat4  mDepthBiasMVP;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec3 P; // Position

varying float fogValue;
varying vec3 ShadowCoord;

void main()
{
  C = vaColor;
  L = normalize(vec3(mView * vec4(uLightPos, 0.0)));
  N = normalize(vec3(mView * vec4(vaNormal, 0.0)));
  P = vPosition;

  // Fog
  #ifdef FOG
    #define FOG_A %
    #define FOG_B %
  
    vec3 rayDir = P - uEyePosition;
    float distance = length(rayDir);
    rayDir = normalize(rayDir);
    fogValue = FOG_A * exp(-uEyePosition.z * FOG_B) * (1.0 - exp(-distance * rayDir.z * FOG_B)) / rayDir.z;
    fogValue = clamp(fogValue, 0.0, 1.0);
  #else
    fogValue = 0.0;
  #endif
  
  // SHADOWS
  ShadowCoord = vec3(mDepthBiasMVP * vec4(vPosition, 1.0));

  gl_Position = mProj * mView * vec4(vPosition, 1.0);
} 
